/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.idm.trident;

import com.filenet.wcm.api.ObjectFactory;
import com.filenet.wcm.api.Session;
import com.filenet.wcm.api.User;
import com.filenet.wcm.apps.server.util.prefs.DefaultPrefsObjects;
import com.filenet.wcm.apps.server.util.prefs.WcmSitePrefs;
import filenet.pe.sso.CookieManager;
import filenet.vw.base.logging.Logger;
import filenet.vw.idm.toolkit.IDMPropertySource;
import filenet.vw.idm.toolkit.IVWIDMFactoryProperties;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import java.applet.Applet;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;

public class VWTridentFactoryProperties
implements IVWIDMFactoryProperties {
    private static final String SMCOOKIES = "SMCOOKIES";
    private static final String NAME = "name";
    private static final String PW = "pw";
    private static final String DOMAIN = "domain";
    private static final String APPLICATION_ID = "eProcess";
    private static Logger logger = Logger.getLogger("filenet.vw.idm");
    private static final String m_className = "VWTridentFactoryProperties";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private String[] m_currentUser = null;
    private Hashtable m_properties = new Hashtable(10);

    public VWTridentFactoryProperties() {
        this.init();
    }

    public VWTridentFactoryProperties(Applet applet) {
        this.init();
        this.getPropertiesFromApplet(applet);
    }

    public VWTridentFactoryProperties(VWCommandLineArgs args) {
        this.getPropertiesFromCommandLine(args);
    }

    public void setProperty(String name, Object value) {
        if (value == null) {
            this.m_properties.remove(name);
            System.setProperty(name, "");
        } else {
            this.m_properties.put(name, value);
            if (value instanceof String) {
                System.setProperty(name, (String)value);
            }
        }
    }

    public Object getProperty(String name) {
        return this.m_properties.get(name);
    }

    protected void setCurrentUser(String user) {
        this.m_currentUser = new String[]{user};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getCurrentUser(Session m_session) {
        String longName = null;
        try {
            try {
                User curUser = m_session.verify();
                longName = curUser.getName();
                this.m_currentUser = new String[2];
                this.m_currentUser[0] = curUser.getPropertyStringValue("ShortName");
                this.m_currentUser[1] = longName;
            }
            catch (Exception e) {
                this.m_currentUser = new String[]{longName == null ? "unknown" : longName};
                this.m_currentUser[0] = longName != null ? longName : "unknown";
                Object var5_6 = null;
                if (logger.isFinest()) {
                    logger.finest(m_className, "getCurrentUser", Logger.asString(this.m_currentUser));
                }
            }
            Object var5_5 = null;
            if (logger.isFinest()) {
                logger.finest(m_className, "getCurrentUser", Logger.asString(this.m_currentUser));
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (logger.isFinest()) {
                logger.finest(m_className, "getCurrentUser", Logger.asString(this.m_currentUser));
            }
            throw throwable;
        }
    }

    private void setWSListenerProperty(String URL2) {
        try {
            final String myURL = URL2 + "/sso";
            Thread tThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void run() {
                    BufferedReader data;
                    block12: {
                        int j;
                        String m_method = "setWSListenerPropertyThread";
                        data = null;
                        URL theURL = new URL(myURL);
                        String SMCookies = (String)VWTridentFactoryProperties.this.getProperty(VWTridentFactoryProperties.SMCOOKIES);
                        if (SMCookies == null) {
                            String line;
                            URLConnection conn = theURL.openConnection();
                            if (logger.isFinest()) {
                                logger.finest(VWTridentFactoryProperties.m_className, m_method, "We're connecting " + myURL);
                            }
                            conn.connect();
                            data = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                            while ((line = data.readLine()) != null) {
                                if (!logger.isFinest()) continue;
                                logger.finest(VWTridentFactoryProperties.m_className, m_method, "Line = " + line);
                            }
                            data.close();
                            return;
                        }
                        StringBuffer res = new StringBuffer();
                        CookieManager.checkSMCookies(SMCookies, theURL, res);
                        String resContents = res.toString();
                        int i = resContents.indexOf("listener.base.url=[");
                        if (i == -1 || (j = resContents.indexOf("]", i)) == -1) break block12;
                        String s = resContents.substring(i + "listener.base.url=[".length(), j).trim();
                        if (logger.isFinest()) {
                            logger.finest(VWTridentFactoryProperties.m_className, m_method, s);
                        }
                        if (s.length() <= 0) break block12;
                        VWTridentFactoryProperties.this.setProperty("nonSSO.listener.base.url", s);
                    }
                    Object var12_13 = null;
                    if (data == null) return;
                    try {
                        data.close();
                        return;
                    }
                    catch (Exception e) {}
                    return;
                    {
                        catch (Throwable throwable) {
                            Object var12_14 = null;
                            if (data == null) return;
                            try {
                                data.close();
                                return;
                            }
                            catch (Exception e) {}
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var12_15 = null;
                        if (data == null) throw throwable;
                        try {
                            data.close();
                            data = null;
                            throw throwable;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            });
            tThread.start();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void getCommonProperties(IDMPropertySource properties) throws Exception {
        String simulationGUID;
        String scenarioDefinitionGUID;
        block21: {
            boolean hasSessionId;
            String wsListenerURL;
            String m_method = "getCommonProperties";
            String s = properties.getProperty("defaultRouter");
            if (s != null) {
                this.setProperty("defaultRouter", s);
            }
            String webServerURL = null;
            String uploadURL = null;
            String downloadURL = null;
            webServerURL = properties.getProperty("webServerURL");
            logger.info(m_className, "getCommonProperties", "webServerURL=" + (webServerURL == null ? "NULL" : webServerURL));
            this.setProperty("webServerURL", webServerURL);
            uploadURL = properties.getProperty("webServerUploadURL");
            logger.info(m_className, "getCommonProperties", "webServerUploadURL=" + (uploadURL == null ? "NULL" : uploadURL));
            this.setProperty("webServerUploadURL", uploadURL);
            downloadURL = properties.getProperty("webServerDownloadURL");
            logger.info(m_className, "getCommonProperties", "webServerDownloadURL=" + (downloadURL == null ? "NULL" : downloadURL));
            this.setProperty("webServerDownloadURL", downloadURL);
            String sessionTunnelURL = properties.getProperty("sessionTunnelURL");
            logger.info(m_className, "getCommonProperties", "sessionTunnelURL=" + (sessionTunnelURL == null ? "NULL" : sessionTunnelURL));
            this.setProperty("sessionTunnelURL", sessionTunnelURL);
            String baseURL = properties.getProperty("baseURL");
            logger.info(m_className, "getCommonProperties", "baseURL=" + (baseURL == null ? "NULL" : baseURL));
            if (baseURL != null) {
                this.setProperty("baseURL", baseURL);
                String vwSoapServletURL = baseURL + "vwsoaprouter";
                logger.info(m_className, "getCommonProperties", "vwSoapServlet=" + (vwSoapServletURL == null ? "NULL" : vwSoapServletURL));
                this.setProperty("vwSoapServlet", vwSoapServletURL);
            }
            if ((wsListenerURL = properties.getProperty("p8bpm.listener.url")) == null && baseURL != null) {
                wsListenerURL = baseURL + "P8BPMWSBroker";
            }
            if (wsListenerURL != null) {
                logger.info(m_className, "getCommonProperties", "p8bpm.listener.url=" + wsListenerURL);
                this.setProperty("p8bpm.listener.url", wsListenerURL);
                this.setWSListenerProperty(wsListenerURL);
            }
            String sessionId = null;
            sessionId = (String)this.getProperty(SMCOOKIES);
            if (sessionId == null) {
                String requestInformation = properties.getProperty("requestInformation");
                logger.info(m_className, "getCommonProperties", "requestInformation=" + (requestInformation == null ? "NULL" : requestInformation));
                String string = sessionId = requestInformation != null ? requestInformation : properties.getProperty("sessionId");
            }
            if (sessionId != null) {
                sessionId = sessionId.replace(',', ';').trim();
            }
            logger.info(m_className, "getCommonProperties", "sessionId=" + (sessionId == null ? "NULL" : sessionId));
            boolean bl = hasSessionId = sessionId != null && sessionId.length() > 0;
            if (hasSessionId) {
                this.setProperty("sessionId", sessionId);
            }
            Session m_session = null;
            String token = (String)this.getProperty("token");
            if (sessionTunnelURL != null && sessionTunnelURL.length() > 0) {
                String[] cookies = null;
                if (hasSessionId) {
                    cookies = sessionId.split(";");
                    if (logger.isFinest()) {
                        logger.finest(m_className, "getCommonProperties", Logger.asString(cookies));
                    }
                }
                String clsName = "com.filenet.wcm.toolkit.client.util.AppletSessionTunnel";
                Class<?> appletSessionTunnelCls = Class.forName(clsName);
                Method createSourceSessionMethod = appletSessionTunnelCls.getDeclaredMethod("createSourceSession", String.class, String.class);
                Constructor<?> ctor = appletSessionTunnelCls.getConstructor(String.class, new String[0].getClass());
                Object appletSessionTunnelObj = ctor.newInstance(sessionTunnelURL, cookies);
                m_session = (Session)createSourceSessionMethod.invoke(appletSessionTunnelObj, APPLICATION_ID, token);
                m_session.setLocale(Locale.getDefault());
                if (logger.isFinest()) {
                    logger.finest(m_className, "getCommonProperties", "Successfully getting Session via AppletSessionTunnel at " + sessionTunnelURL + ", " + sessionId + ", " + token);
                }
            } else {
                m_session = token != null ? ObjectFactory.getSession((String)APPLICATION_ID, (String)"Clear", (String)token, null) : ObjectFactory.getSession((String)APPLICATION_ID, (String)"Clear", (String)((String)this.getProperty(NAME)), (String)((String)this.getProperty(PW)));
                if (hasSessionId) {
                    Hashtable<String, String> header = new Hashtable<String, String>();
                    header.put("Cookie", sessionId);
                    m_session.setTransportHeaders(header);
                }
                m_session.setRemoteServerUrl(webServerURL);
                m_session.setRemoteServerUploadUrl(uploadURL);
                m_session.setRemoteServerDownloadUrl(downloadURL);
            }
            this.getCurrentUser(m_session);
            this.setProperty("Session", m_session);
            String prefToken = properties.getProperty("sitePreferences");
            if (prefToken != null) {
                try {
                    WcmSitePrefs sitePreferences = this.getSitePrefs(URLDecoder.decode(prefToken, DEFAULT_ENCODING));
                    String defPrefToken = properties.getProperty("defaultPrefsObjects");
                    if (defPrefToken != null) {
                        DefaultPrefsObjects m_DefaultPrefsObjects = new DefaultPrefsObjects();
                        String xml = URLDecoder.decode(defPrefToken, DEFAULT_ENCODING);
                        m_DefaultPrefsObjects.load(xml);
                        sitePreferences.setDefaultPrefsObjects(m_DefaultPrefsObjects);
                    }
                    if (sitePreferences == null) break block21;
                    this.setProperty("sitePreferences", sitePreferences);
                    int filterFolderMaxResults = 100;
                    try {
                        filterFolderMaxResults = sitePreferences.getFilterFolderMaxResults();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    this.setProperty("filterFolderMaxResults", new Integer(filterFolderMaxResults));
                }
                catch (Exception e) {
                    if (!logger.isFinest()) break block21;
                    logger.finest(m_className, "getCommonProperties", "Ignore exception e:" + e.getMessage());
                }
            }
        }
        if ((scenarioDefinitionGUID = properties.getProperty("ScenarioDefinition")) != null) {
            this.setProperty("ScenarioDefinition", scenarioDefinitionGUID);
        }
        if ((simulationGUID = properties.getProperty("Simulation")) != null) {
            this.setProperty("Simulation", simulationGUID);
        }
    }

    public void getPropertiesFromApplet(Applet applet) {
        String m_method = "getPropertiesFromApplet";
        if (applet == null) {
            return;
        }
        logger.entering(m_className, m_method);
        try {
            String SMCookies;
            this.setProperty("applet", applet);
            String paramValue = applet.getParameter("token");
            if (paramValue != null) {
                logger.info(m_className, m_method, "token=" + paramValue);
                this.setProperty("token", paramValue);
            }
            if ((SMCookies = CookieManager.checkSMCookiesForApplet(applet, (String)this.getProperty("requestInformation"))) != null) {
                this.setProperty(SMCOOKIES, SMCookies);
            }
            this.getCommonProperties(new IDMPropertySource(applet));
        }
        catch (Throwable e) {
            logger.throwing(m_className, m_method, e);
        }
        logger.exiting(m_className, m_method);
    }

    public void getPropertiesFromPropertiesBag(Properties properties) {
        String m_method = "getPropertiesFromPropertiesBag";
        try {
            String token = properties.getProperty("token");
            String name = properties.getProperty(NAME);
            String pw = properties.getProperty(PW);
            String domain = properties.getProperty(DOMAIN);
            this.m_currentUser = new String[1];
            if (token != null) {
                this.m_currentUser[0] = token;
                this.setProperty("token", token);
            } else {
                this.setProperty(NAME, name);
                this.m_currentUser[0] = name;
            }
            if (pw != null) {
                this.setProperty(PW, pw);
            }
            if (domain != null) {
                this.setProperty(DOMAIN, domain);
            }
            this.getCommonProperties(new IDMPropertySource(properties));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getPropertiesFromCommandLine(VWCommandLineArgs args) {
        String m_method = "getPropertiesFromCommandLine";
        try {
            String token = args.getParameter("token");
            String name = args.getParameter(NAME);
            String pw = args.getParameter(PW);
            String domain = args.getParameter(DOMAIN);
            this.m_currentUser = new String[1];
            if (token != null) {
                this.m_currentUser[0] = token;
                this.setProperty("token", token);
            } else {
                this.setProperty(NAME, name);
                this.m_currentUser[0] = name;
            }
            this.setProperty(PW, pw);
            this.setProperty(DOMAIN, domain);
            this.getCommonProperties(new IDMPropertySource(args));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Session getSession() {
        return (Session)this.m_properties.get("Session");
    }

    public WcmSitePrefs getWcmSitePrefs() {
        return (WcmSitePrefs)this.m_properties.get("sitePreferences");
    }

    public Applet getApplet() {
        return (Applet)this.m_properties.get("applet");
    }

    public String[] getCurrentUser() {
        return this.m_currentUser;
    }

    private void init() {
    }

    private WcmSitePrefs getSitePrefs(String prefsXML) throws Exception {
        WcmSitePrefs sitePrefs = new WcmSitePrefs();
        sitePrefs.load(prefsXML);
        return sitePrefs;
    }

    public static void main(String[] args) {
        try {
            String xml;
            VWCommandLineArgs c = new VWCommandLineArgs(args);
            String inputfile = c.getParameter("inputfile");
            if (inputfile == null) {
                System.out.println("Nothing todo");
                System.exit(0);
            }
            c = new VWCommandLineArgs(inputfile, false);
            String sitePreferencesStr = c.getParameter("sitePreferences");
            System.out.println("sitePreferences=" + sitePreferencesStr);
            String defaultPrefsObjectsStr = c.getParameter("defaultPrefsObjects");
            System.out.println("defaultPrefs=" + defaultPrefsObjectsStr);
            if (sitePreferencesStr != null) {
                try {
                    WcmSitePrefs sitePrefs = new WcmSitePrefs();
                    xml = URLDecoder.decode(sitePreferencesStr, DEFAULT_ENCODING);
                    System.out.println("\n-------- Site Preferences XML version ----");
                    System.out.println(xml);
                    sitePrefs.load(xml);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (defaultPrefsObjectsStr != null) {
                try {
                    DefaultPrefsObjects m_DefaultPrefsObjects = new DefaultPrefsObjects();
                    xml = URLDecoder.decode(defaultPrefsObjectsStr, DEFAULT_ENCODING);
                    System.out.println("\n-------- Default Objects XML version ----");
                    System.out.println(xml);
                    m_DefaultPrefsObjects.load(xml);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

